drop _all
set more 1
set linesize 240
capture log close
drop _all
set logtype text
set memory 300m

*
* Run programs that create the charts and tables for 
* "Is A Household Debt Overhang Holding Back Consumption?"
*
* Written by Karen Dynan

cd "F:\BPEA\Dynan Data and Programs"

disp "Remember to create the 'logfiles' and 'graphs' subdirectory if you don't have them already."
/*
* The program below creates the data set used for the charts and tables. 
* I'm including it here for reference but it doesn't need to be run because I am providing 
* the data set it produces (bpea_data.dta).

  *capture program drop make_bpea_data
  *run make_bpea_data
  *make_bpea_data

* Run the programs that produce the information for the tables.

* Tables 1-3

  capture program drop table1_dynan
  run table1_dynan
  table1_dynan

  capture program drop table2_dynan
  run table2_dynan
  table2_dynan

  capture program drop table3_dynan
  run table3_dynan
  table3_dynan

* Tables 4-6: These programs run and table many regressions.
* I only showed select specifications in the paper.
 
  capture program drop table456_dynan
  run table456_dynan

* Permutation 1: all households, OLS, 2007-2009
* Table 4 column (1): taken from column (1) of first table in this packet
*         column (3): taken from column (4) of first table in this packet
*         column (4): taken from column (1) of second table in this packet
*         column (5): taken from column (4) of second table in this packet
*         column (6): taken from column (2) of first table in this packet
* Table 5 column (1): taken from column (1) of third table in this packet
*         column (3): taken from column (4) of third table in this packet
*         column (4): taken from column (1) of fourth table in this packet
*         column (5): taken from column (4) of fourth table in this packet
*         column (6): taken from column (2) of third table in this packet
* Table 5 column (1): taken from column (1) of fifth table in this packet

  table456_dynan 1

* Permutation 2: like permutation 1, changing dependent variable to del(C/Yavg)
* Table 4 column (2): taken from column (1) of first table in this packet
* Table 5 column (2): taken from column (1) of third table in this packet

  table456_dynan 2

* Permutation 3: like permutation 1, but using ex post leverage
* Table 4 column (7): taken from column (1) of first table in this packet

  table456_dynan 3

* Permutation 4: like permutation 1, but estimated for 2005-2007 change
* Table 4 column (9): taken from column (1) of first table in this packet
* Table 5 column (9): taken from column (1) of third table in this packet
* Table 6 column (3): taken from column (1) of fifth table in this packet

  table456_dynan 4

* Permutation 5: like permutation 1, but estimated for 2005-2007 and 2007-2009 changes
* Table 4 column (10): taken from column (1) of first table in this packet
* Table 5 column (10): taken from column (1) of third table in this packet
* Table 6 column (4): taken from column (1) of fifth table in this packet

  table456_dynan 5

* Permutation 6: like permutation 1, but with interactions for unemployment rate
* Table 5 column (7): taken from column (1) of third table in this packet

  table456_dynan 6

* Permutation 7: like permutation 1, but with interactions for del(unemployment rate)
* Table 5 column (8): taken from column (1) of third table in this packet

  table456_dynan 7

* Permutation 8: constrained regression, imposing that the coefficient on wealth equals 0.05.
* Not tabled, but referenced in the paper

  table456_dynan 8
*/
* IV variant, permutation 1: table 4 specification
* Table 4 column (8): taken from column (1) of first table in this packet

  capture program drop table46iv_dynan
  run table46iv_dynan

  table46iv_dynan 1

* IV variant, permutation 2: table 4 specification
* Table 4 column (2): taken from column (1) of first table in this packet


  table46iv_dynan 2

* Table 7
 
  capture program drop table7_dynan
  run table7_dynan
  table7_dynan

* Table 8

  capture program drop table8_dynan
  run table8_dynan
  table8_dynan

* Figure 4

  capture program drop figure4_dynan
  run figure4_dynan
  figure4_dynan

* Figure 5

  capture program drop figure5_dynan
  run figure5_dynan
  figure5_dynan

